/*
--'--------------------------------------------------------------------------------------------------'
--' 05/07/2021 Occhialini Lorenzo             Implementazione N.156609 del 11/01/2021 - Fase 163112  '
--' 25/11/2020 Occhialini Lorenzo             Implementazione N.155377 del 23/11/2020 - Fase 155379  '
--' 2017.05.26 Cofini Romolo                  Team Foundation Server Id 082860                       '
--' 17/10/2016 Occhialini Lorenzo             Implementazione N.61612 del 11/10/2016 - Fase 61619    '
--' Inserita la condizione sul campo CG68_FLGNOLIQIVA per non considerare i record della CG43_MOVIVA '
--' di sezionali di tipologia IVA ma che non devono essere considerati nelle elaborazioni IVA        '
--'--------------------------------------------------------------------------------------------------'
*/

IF EXISTS (SELECT TOP 1 1
           FROM dbo.sysobjects
           WHERE id = object_id(N'[dbo].[FNCG_DATI_TESSERA_SANITARIA]')
           AND xtype in (N'FN', N'IF', N'TF'))
DROP FUNCTION [dbo].[FNCG_DATI_TESSERA_SANITARIA]
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE FUNCTION FNCG_DATI_TESSERA_SANITARIA(
                                             @AZIENDA DECIMAL(5,0),
                                             @DATAINI DATETIME,
                                             @DATAFIN DATETIME
                                           )
RETURNS @TAB TABLE
    ( CG41_DITTA_CG18 DECIMAL(5,0) NOT NULL,
      CG41_NUMREG NCHAR(12) NOT NULL,
      CG41_INDTIPOMOV DECIMAL(2,0) NOT NULL,
      CG41_INDTIPOREG DECIMAL(1,0) NOT NULL,
      CG41_CODICE_CG31 DECIMAL(5,0) NOT NULL,
      CG41_ANNO_CG19 DECIMAL(4,0) NOT NULL,
      CG41_PROGESER_CG19 DECIMAL(2,0) NOT NULL,
      CG41_DATAREG DATETIME NOT NULL,
      CG41_CODICE_CG33 NCHAR(4) NOT NULL,
      CG41_DESCAUSALE NVARCHAR(40) NULL,
      CG41_DESCRAGG NVARCHAR(240) NULL,
      CG41_TIPOCF_CG44 DECIMAL(1,0) NULL,
      CG41_CLIFOR_CG44 DECIMAL(8,0) NULL,
      CG41_SEZIONALE NCHAR(2) NOT NULL,
      CG41_NUMDOC DECIMAL(7,0) NOT NULL,
      CG41_FLGDOCBIS DECIMAL(1,0) NOT NULL,
      CG41_DATADOC DATETIME NULL,
      CG41_NUMDOCORIG NCHAR(15) NULL,
      CG41_IMPTOTALE DECIMAL(17,2) NULL,
      CG43_NUMRIGAIVA DECIMAL(5,0) NOT NULL,
      CG43_GRUPPO_CG10 DECIMAL(2,0) NOT NULL,
      CG43_IMPONIBILE DECIMAL(17,2) NOT NULL,
      CG43_ALIQIVA1_CG28 NCHAR(4) NOT NULL,
	  CG28_PERCIVA DECIMAL(5,2) NULL,
      CG43_IMPOSTA DECIMAL(17,2) NOT NULL,
	  CG43_INDNATURA INT NULL,
	  CG28_INDNATURA INT NULL,
      CG43_CONTO_CG24 NCHAR(10) NOT NULL,
      CG43_INDTSTIPOOP TINYINT NOT NULL,
      CG43_INDTSVOCESP TINYINT NOT NULL,
      CG43_INDTSTIPOSP TINYINT NOT NULL,
      CG43_TSDOCORIGINE NVARCHAR(15) NULL,
      CG43_TSDATADOCORI DATETIME,
      CG43_FLGTSESCLUSO TINYINT NOT NULL,
      CG43_FLGTSINVIATO TINYINT NOT NULL,
	  CG43_FLGTSPAGTRAC TINYINT NOT NULL,
	  CG43_INDTSTIPODOC TINYINT NOT NULL,
	  CG43_FLGTSOPPOSIZ TINYINT NOT NULL,
      CG43_INDTIPO DECIMAL(2,0) NOT NULL,
      IMPORTO_RIPROP DECIMAL(17,2) NOT NULL,
      DATAREG_MAX DATETIME NOT NULL,
      ESERCIZIO NVARCHAR(7) NOT NULL
    )
AS
/*
--'--------------------------------------------------------------------------------------------------'
--' 2017.05.26 Cofini Romolo                  Team Foundation Server Id 082860                       '
--'--------------------------------------------------------------------------------------------------'
*/
BEGIN
    INSERT INTO @TAB
    ( CG41_DITTA_CG18,       CG41_NUMREG,           CG41_INDTIPOMOV,
      CG41_INDTIPOREG,       CG41_CODICE_CG31,      CG41_ANNO_CG19,
      CG41_PROGESER_CG19,    CG41_DATAREG,          CG41_CODICE_CG33,
      CG41_DESCAUSALE,       CG41_DESCRAGG,         CG41_TIPOCF_CG44,
      CG41_CLIFOR_CG44,      CG41_SEZIONALE,        CG41_NUMDOC,
      CG41_FLGDOCBIS,        CG41_DATADOC,          CG41_NUMDOCORIG,
      CG41_IMPTOTALE,        CG43_NUMRIGAIVA,       CG43_GRUPPO_CG10,
      CG43_IMPONIBILE,       CG43_ALIQIVA1_CG28,    CG28_PERCIVA,
	  CG43_IMPOSTA,			 CG43_INDNATURA,        CG28_INDNATURA,
	  CG43_CONTO_CG24,  	 CG43_INDTSTIPOOP,      CG43_INDTSVOCESP,
	  CG43_INDTSTIPOSP,	     CG43_TSDOCORIGINE,     CG43_TSDATADOCORI,
	  CG43_FLGTSESCLUSO,	 CG43_FLGTSINVIATO,     CG43_FLGTSPAGTRAC,
	  CG43_INDTSTIPODOC,	 CG43_FLGTSOPPOSIZ,     CG43_INDTIPO,
	  IMPORTO_RIPROP,	     DATAREG_MAX,	        ESERCIZIO
    )
    SELECT CG41_DITTA_CG18,      CG41_NUMREG,           CG41_INDTIPOMOV,
           CG41_INDTIPOREG,      CG41_CODICE_CG31,      CG41_ANNO_CG19,
           CG41_PROGESER_CG19,   CG41_DATAREG,          CG41_CODICE_CG33,
           CG41_DESCAUSALE,      CG41_DESCRAGG,         CG41_TIPOCF_CG44,
           CG41_CLIFOR_CG44,     CG41_SEZIONALE,        CG41_NUMDOC,
           CG41_FLGDOCBIS,       CG41_DATADOC,          CG41_NUMDOCORIG,
           CG41_IMPTOTALE,       CG43_NUMRIGAIVA,       CG43_GRUPPO_CG10,
           CG43_IMPONIBILE,      CG43_ALIQIVA1_CG28,    CG28_PERCIVA,
		   CG43_IMPOSTA,         CG43_INDNATURA,        CG28_INDNATURA,
		   CG43_CONTO_CG24,		 CG43_INDTSTIPOOP,      CG43_INDTSVOCESP,
		   CG43_INDTSTIPOSP,     CG43_TSDOCORIGINE,     CG43_TSDATADOCORI,
		   CG43_FLGTSESCLUSO,    CG43_FLGTSINVIATO,     CG43_FLGTSPAGTRAC,
		   CG43_INDTSTIPODOC,    CG43_FLGTSOPPOSIZ,     CG43_INDTIPO,
           CAST(   CAST((ISNULL(CG43_IMPONIBILE,0) + ISNULL(CG43_IMPOSTA,0)) AS DECIMAL(17,2))
                 * CAST(PAG_PERC.PERC AS DECIMAL(18,17)) AS DECIMAL(17,2)) AS IMPORTO_RIPROP,
           PAG_PERC.DATAREG_MAX,
           CAST(CG41_ANNO_CG19 AS VARCHAR(4)) + '/' + CAST(CG41_PROGESER_CG19 AS VARCHAR(2)) AS ESERCIZIO
    FROM (
            SELECT PAG.TIPO_DOC, PAG.DITTA, PAG.NUMREG, PAG.TOTALE_DOC, PAG.INCASSATO, PAG.DATAREG_MAX,
                   CAST(CASE WHEN ISNULL(PAG.TOTALE_DOC,0) <= ISNULL(PAG.INCASSATO,0)
                             THEN 1
                             ELSE CASE WHEN ISNULL(PAG.TOTALE_DOC,0) = 0
                                       THEN 0
                                       ELSE ISNULL(CAST(PAG.INCASSATO AS DECIMAL(17,2)) ,0) / ISNULL(CAST(PAG.TOTALE_DOC AS DECIMAL(17,2)) ,0)
                                  END
                        END AS DECIMAL(18,17)) AS PERC
            FROM (
                    SELECT CASE WHEN ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                THEN 'N'
                                ELSE 'F'
                           END AS TIPO_DOC,
                           EF06_A.EF06_DITTA_CG18 AS DITTA, EF06_A.EF06_NUMREG_CO99 AS NUMREG,
                           ISNULL(CG41_A.CG41_IMPTOTALE,0) AS TOTALE_DOC,
                           MAX(EF06_A.EF06_DATAREG) AS DATAREG_MAX,
                           -- PAGATO EURO
                           ISNULL(SUM(CASE WHEN EF06_A.EF06_INDTIPOPER IN (1, 2, 4, 5, 6, 14)
                                           THEN CASE WHEN ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                                     THEN -(ISNULL(EF06_A.EF06_IMPMOVPAG,0)) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                     ELSE CASE WHEN EF06_A.EF06_INDTIPOPER = 5
                                                               THEN CASE WHEN EF06_A.EF06_RIGACONTMOV_CG42 > 1
                                                                         THEN ISNULL(EF06_A.EF06_IMPMOVPAG,0) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                                         ELSE 0
                                                                    END
                                                               ELSE ISNULL(EF06_A.EF06_IMPMOVPAG,0) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                          END
                                                END
                                      END),0)
                           -- ABBUONO EURO
                           +
                           ISNULL(SUM(CASE WHEN EF06_A.EF06_INDTIPOPER IN (1, 2, 4, 5, 6, 14)
                                           THEN CASE WHEN ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                                     THEN -(ISNULL(EF06_A.EF06_IMPMOVABB,0)) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                     ELSE ISNULL(EF06_A.EF06_IMPMOVABB,0) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                END
                                      END),0)
                           -- ACCONTO EURO
                           +
                           ISNULL(SUM(CASE WHEN EF06_A.EF06_NUMREG_CO99 = EF06_A.EF06_NUMREGMOV_CO99
                                           THEN CASE WHEN ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                                     THEN -(ISNULL(EF06_A.EF06_IMPMOVACC,0)) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                     ELSE ISNULL(EF06_A.EF06_IMPMOVACC,0) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                                END
                                           ELSE 0
                                      END),0)
                           -- SCONTO INCONDIZIONATO EURO
                           +
                           ISNULL(SUM(CASE WHEN ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                           THEN -(ISNULL(EF06_A.EF06_IMPMOVSCIND,0)) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                           ELSE ISNULL(EF06_A.EF06_IMPMOVSCIND,0) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                      END),0)
                           -- OMAGGI SENZA RIVALSA
                           +
                           ISNULL(SUM(CASE WHEN ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                           THEN -(ISNULL(EF06_A.EF06_IMPMOVOMANORIV,0)) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                           ELSE ISNULL(EF06_A.EF06_IMPMOVOMANORIV,0) * ( CASE WHEN EF06_A.EF06_INDTIPOPER = 4 THEN -1 ELSE 1 END )
                                      END),0)
                           AS INCASSATO
                    --
                    -- Considero i record della EF06_SCADSTO "validi", ovvero quelli che non sono stati generati
                    -- da insoluto oppure quelli generati da insoluto per i quali esiste la corrispondente riga
                    -- di incasso (chiusura) precedente all'insoluto e compresa nell'intervallo di elaborazione
                    --
                    -- FROM EF06_SCADSTO EF06_A WITH (NOLOCK)
                    --
                    FROM (
                            SELECT EF06_MAIN.*
                            FROM EF06_SCADSTO EF06_MAIN WITH (NOLOCK)
                                LEFT OUTER JOIN (
                                                    SELECT EF06_INS.EF06_DITTA_CG18 AS DITTA, EF06_INS.EF06_NUMREG_CO99 AS NUMREG,
                                                           EF06_INS.EF06_RIGACONT_EF01 AS RIGACONT, EF06_INS.EF06_PROGEC_EF01 AS PROGEC,
                                                           EF06_INS.EF06_PROGEFF_EF01 AS PROGEFF, EF06_INS.EF06_PROGSTO AS PROGSTO
                                                    FROM EF06_SCADSTO EF06_INS WITH (NOLOCK)
                                                    WHERE EF06_INS.EF06_DITTA_CG18 = @AZIENDA
                                                    AND EF06_INS.EF06_DATAREG BETWEEN @DATAINI
                                                                                  AND @DATAFIN
                                                    AND EF06_INS.EF06_INDTIPOPER = 4
                                                    -- Condizione per elaborare solo la prima riga di storico di tipo "insoluto"
                                                    AND EF06_INS.EF06_PROGSTO = ( SELECT MIN(EF06_SUB.EF06_PROGSTO)
                                                                                  FROM EF06_SCADSTO EF06_SUB WITH (NOLOCK)
                                                                                  WHERE EF06_SUB.EF06_DITTA_CG18 = EF06_INS.EF06_DITTA_CG18
                                                                                  AND EF06_SUB.EF06_NUMREG_CO99 = EF06_INS.EF06_NUMREG_CO99
                                                                                  AND EF06_SUB.EF06_RIGACONT_EF01 = EF06_INS.EF06_RIGACONT_EF01
                                                                                  AND EF06_SUB.EF06_PROGEC_EF01 = EF06_INS.EF06_PROGEC_EF01
                                                                                  AND EF06_SUB.EF06_PROGEFF_EF01 = EF06_INS.EF06_PROGEFF_EF01
                                                                                  AND EF06_SUB.EF06_DATAREG BETWEEN @DATAINI
                                                                                                                AND @DATAFIN
                                                                                  AND EF06_SUB.EF06_INDTIPOPER = 4
                                                                                )
                                                    -- Condizione per valutare se esiste un record di tipo "incasso / pagamento / chiusura"
                                                    -- con progressivo minore dell'insoluto
                                                    AND NOT EXISTS ( SELECT 1
                                                                     FROM EF06_SCADSTO EF06_SUB WITH (NOLOCK)
                                                                     WHERE EF06_SUB.EF06_DITTA_CG18 = EF06_INS.EF06_DITTA_CG18
                                                                     AND EF06_SUB.EF06_NUMREG_CO99 = EF06_INS.EF06_NUMREG_CO99
                                                                     AND EF06_SUB.EF06_RIGACONT_EF01 = EF06_INS.EF06_RIGACONT_EF01
                                                                     AND EF06_SUB.EF06_PROGEC_EF01 = EF06_INS.EF06_PROGEC_EF01
                                                                     AND EF06_SUB.EF06_PROGEFF_EF01 = EF06_INS.EF06_PROGEFF_EF01
                                                                     AND EF06_SUB.EF06_PROGSTO < EF06_INS.EF06_PROGSTO
                                                                     AND EF06_SUB.EF06_INDTIPOPER IN (1,2)
                                                                     AND EF06_SUB.EF06_DATAREG BETWEEN @DATAINI
                                                                                                   AND @DATAFIN
                                                                   )
                                                ) TAB_INS
                                    ON TAB_INS.DITTA = EF06_MAIN.EF06_DITTA_CG18
                                    AND TAB_INS.NUMREG = EF06_MAIN.EF06_NUMREG_CO99
                                    AND TAB_INS.RIGACONT = EF06_MAIN.EF06_RIGACONT_EF01
                                    AND TAB_INS.PROGEC = EF06_MAIN.EF06_PROGEC_EF01
                                    AND TAB_INS.PROGEFF = EF06_MAIN.EF06_PROGEFF_EF01
                                    AND TAB_INS.PROGSTO = EF06_MAIN.EF06_PROGSTO
                            WHERE (CASE WHEN TAB_INS.DITTA IS NULL
                                        THEN 1
                                        ELSE CASE WHEN TAB_INS.PROGSTO > EF06_MAIN.EF06_PROGSTO
                                                  THEN 1
                                                  ELSE 0
                                             END
                                   END) = 1
                         ) EF06_A
                        INNER JOIN EF01_SCADENZE EF01_A WITH (NOLOCK)
                            ON EF01_A.EF01_DITTA_CG18 = EF06_A.EF06_DITTA_CG18
                            AND EF01_A.EF01_NUMREG_CO99 = EF06_A.EF06_NUMREG_CO99
                            AND EF01_A.EF01_RIGACONT_CG42 = EF06_A.EF06_RIGACONT_EF01
                            AND EF01_A.EF01_PROGEC_EC01 = EF06_A.EF06_PROGEC_EF01
                            AND EF01_A.EF01_PROGEFF = EF06_A.EF06_PROGEFF_EF01
                        LEFT OUTER JOIN CG41_PRIMANOTA CG41_A WITH (NOLOCK)
                            ON EF06_A.EF06_DITTA_CG18 = CG41_A.CG41_DITTA_CG18
                            AND EF06_A.EF06_NUMREG_CO99 = CG41_A.CG41_NUMREG
                        LEFT OUTER JOIN CG33_TABCAU CG33_A WITH (NOLOCK)
                            ON CG41_A.CG41_CODICE_CG33 = CG33_A.CG33_CODICE
                    WHERE EF06_A.EF06_DITTA_CG18 = @AZIENDA
                    AND EF06_A.EF06_DATAREG BETWEEN @DATAINI
                                                AND @DATAFIN
                    AND EF01_A.EF01_TIPOCF_CG44 = 0
                    AND EF06_A.EF06_INDTIPOPER IN (1, 2, 4, 5, 6, 14)
                    AND CG41_A.CG41_INDTIPOREG = 2
                    AND (    -- FATTURA: non considero i record relativi all'associazione di note credito alla fattura
                             (
                                   (ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) NOT IN ('5','35','42','52','63','81','92','97','285'))
                               AND NOT EXISTS ( SELECT TOP 1 1
                                                FROM CG41_PRIMANOTA CG41_NC WITH (NOLOCK)
                                                    INNER JOIN CG33_TABCAU CG33_NC WITH (NOLOCK)
                                                        ON CG41_NC.CG41_CODICE_CG33 = CG33_NC.CG33_CODICE
                                                WHERE CG41_NC.CG41_DITTA_CG18 = EF06_A.EF06_DITTA_CG18
                                                AND CG41_NC.CG41_NUMREG = EF06_A.EF06_NUMREGMOV_CO99
                                                AND ISNULL(CG33_NC.CG33_CAUSALEIVA, CG33_NC.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285')
                                              )
                             )
                          OR
                             -- NOTA CREDITO NON ASSOCIATA
                             (
                                   (ISNULL(CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE) IN ('5','35','42','52','63','81','92','97','285'))
                               AND NOT EXISTS ( SELECT 1
                                                FROM EF06_SCADSTO EF06_B WITH (NOLOCK)
                                                    INNER JOIN CG41_PRIMANOTA CG41_B WITH (NOLOCK)
                                                        ON CG41_B.CG41_DITTA_CG18 = EF06_B.EF06_DITTA_CG18
                                                        AND CG41_B.CG41_NUMREG = EF06_B.EF06_NUMREG_CO99
                                                WHERE EF06_B.EF06_DITTA_CG18 = EF06_A.EF06_DITTA_CG18
                                                AND   EF06_B.EF06_NUMREG_CO99 = EF06_A.EF06_NUMREG_CO99
                                                AND    EF06_B.EF06_RIGACONT_EF01 = EF06_A.EF06_RIGACONT_EF01
                                                AND    EF06_B.EF06_PROGEC_EF01 = EF06_A.EF06_PROGEC_EF01
                                                AND    EF06_B.EF06_PROGEFF_EF01 = EF06_A.EF06_PROGEFF_EF01
                                                --
                                                AND    EF06_B.EF06_NUMREGMOV_CO99 = EF06_A.EF06_NUMREG_CO99
                                                --
                                                AND    CG41_B.CG41_INDTIPOREG IN (1,2)
                                              )
                             )
                        )
                    GROUP BY EF06_A.EF06_DITTA_CG18, EF06_A.EF06_NUMREG_CO99, CG41_A.CG41_IMPTOTALE, CG33_A.CG33_CAUSALEIVA, CG33_A.CG33_CODICE
            ) PAG
         ) PAG_PERC
        INNER JOIN CG43_MOVIVA WITH (NOLOCK)
            ON CG43_DITTA_CG18 = PAG_PERC.DITTA
            AND CG43_NUMREG_CG41 = PAG_PERC.NUMREG
        INNER JOIN CG41_PRIMANOTA WITH(NOLOCK)
            ON CG41_DITTA_CG18 = CG43_DITTA_CG18
            AND CG41_NUMREG = CG43_NUMREG_CG41
        INNER JOIN CG68_NUMERDESC WITH(NOLOCK)
            ON CG41_DITTA_CG18 = CG68_DITTA_CG18
            AND CG41_SEZIONALE = CG68_SEZIONALE
		LEFT OUTER JOIN CG28_TABCODIVA WITH(NOLOCK)
		    ON CG28_CODICE = CG43_ALIQIVA1_CG28
    WHERE ISNULL(PAG_PERC.PERC,0) > 0
    AND ISNULL(CG43_IMPONIBILE,0) + ISNULL(CG43_IMPOSTA,0) > 0
	AND CG68_FLGNOLIQIVA = 0
    ORDER BY CG43_DITTA_CG18, CG43_NUMREG_CG41, CG43_NUMRIGAIVA
    
    RETURN
END